-- ------------------------------------------------------------
-- Initialization phase

-- Define our custom particle properties
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member


AdditionalVars = { "AppearStars" };
-- dPos is a data source: An external connection to the particle
-- system. Here we define dPos for FluidFX, since FluidFX doesn't know
-- to provide the data source; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dPos then
   dPos= Vec2(0,0) ; 
end
if not AppearStars then
   AppearStars= Vec2(0,0);     
end


-- Set the particle texture
SetTexture("particles_sw.xml");
--SetTexture("cardinal.xml");

-- Set the blend mode
SetBlendMode(kBlendNormal);

-- LAST, we set the total number of particles in the particle
-- system. This doesn't 'create' the particles, but rather
-- allocates a block of 'dead' particles that can be created
-- below.
SetNumParticles(400);    

-- ------------------------------------------------------------
-- Action Phase

-- Particle Initialization Rules.
-- 
-- The following rules define how particles are created.
--
-- Any parameter below in initialization or animation rules that 
-- is a scalar, Color(), or Vec2() can alternaly take a function 
-- that returns the same type--and most functions can take any type
-- and will return that same type. The exception is any function
-- that's expecting a scalar in certain parameter positions.

-- Pick one of two positions randomly, and add dPos.
-- dPos is defined in swarm.cpp and added to the random
-- range
--pPosition:Init( fRange( Vec2(-30,-30), Vec2(30,30) ) + dPos );

pPosition:Init( Vec2( fRange(30,-30), fRange(30,-30)) + dPos + AppearStars);
--pPosition:Init( Vec2( fPick(fRange(30,-10),fRange(10,30)), fPick(fRange(-30,-10),fRange(10,30)) ) + dPos );
-- Pick a velocity from a range
--pVelocity:Init( fRange( Vec2(-20,-20), Vec2(20,20) ) );
--pVelocity:Init( pPosition - dPos );
-- Start color (tint) off as white (natural color of image)
--pColor:Init( Color(fRange(0,1),fRange(0,1),fRange(0,1),1) );

-- Start scale out as 0.5
pScale:Init( 0.7 );

-- Start age as 0 milliseconds
pAge:Init(0);

-- Start initial rotation as a random angle
pSpin:Init( fRange( 0, 2*3.1415927 ) );

-- Start spin velocity random from -10 to 10
pSpinSpeed:Init( fRange( -10, 10 ) );

-- ன
--pFrame:Init( fRange(0,4) );
pFrame:Init( fPick(2,3) );

-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--
-- The following rules define how particles animate.
-- Each rule is applied on each frame of animation.

-- Add velocity scaled by time to position
--pPosition:Anim( pPosition + fTimeScale(pVelocity) );

pScale:Anim( pScale + fTimeScale(1) );
--pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,400)) );
--pColor:Anim( fFade( pAge, pColor, 1000, Color(1,1,1,0) ) );
pColor:Anim( fFade( pAge,Color(1,1,1,0), 300, Color(1,1,1,1),350, Color(1,1,1,0) ) );
--pColor:Anim( fFade( pAge,Color(1,1,0,1), 300, Color(1,0.1,0,1), 350, Color(1,0.4,0,0) ) );

pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pUp:Anim( f2dRotation( pSpin ) );

-- Add time to the age
pAge:Anim( pAge+fAge() );


-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,650) ) );

-- Create an initial particle (optional)
-- CreateParticles( 1 );

-- A global variable that we can set from outside
gActive = true;
gCountTick = 300;
gCounter = 0;
gEndFlag = 0; -- rjulf  -    ,     

function OnStart(aCount)
    gActive = true;
    if (aCount > 0) then
        gCountTick = aCount;
    end
    gCounter = 0;
    gEndFlag = 0;
end
-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
    if gActive then
        if gEndFlag > 0 then
            gEndFlag = gEndFlag - seconds;
            if gEndFlag <=0 then
                gActive = false;
                OnEnd();
            end
        else
            -- Create 10 particles per second
            CreateParticles( seconds * 5);
            gCounter = gCounter + 1;
            if (gCounter > gCountTick) then 
                gEndFlag = 0.650;
            end
        end 
    end
end

